
import { useState, useEffect, useCallback } from 'react'

import ProForm, { ModalForm, ProFormDigit, ProFormSelect, ProFormText } from '@ant-design/pro-form'

import { message } from 'antd'

import { GetDetailApi, UpdateApi, AddApi } from '../common/services'

type TProps = {
  visible: boolean,
  id: number,
  handleUpdateVisible: (value:boolean, type: string) => void
}
const AddUpdate = ({ id, visible, handleUpdateVisible }:TProps) => {
  const [title, setTitle] = useState<string>('')

  useEffect(() => {
    setTitle(() => {
      return id ? '编辑演播室' : '创建演播室'
    })
  }, [visible])
  const fetchDetail = useCallback(async () => {
    let data:any = {
      studioName: '', // 演播室名称
      studioId: '', // 演播室id
      ip1: '', // 主服务ip
      ip2: '', // 备服务ip
      port1: '', // 主服务器端口
      port2: '', // 备服务器端口
      sceneNameS: '', // 主场景地址
      sceneNameQ: '', // 备场景地址
      createTime: '', // 创建时间
      updateTime: '', // 修改时间
      type: '', // 弹幕类型
      intervalTime: 3, // 弹幕轮询时间间隔
      bulletChatNums: 0, // 筛选弹幕限制数量
      powerTime: 3 // 发电时刻开启服务时，默认时间间隔
    }
    if (id) {
      try {
        const res = await GetDetailApi(id)
        if (res.status !== 200) return
        data = res?.data
      } catch (error) {
        console.log(error)
      }
    }
    return data
  }, [id])
  const cnacelClick = () => {
    handleUpdateVisible(false, '')
  }
  const okClick = async (values:any) => {
    const params:any = {
      studioName: values.studioName, // 演播室名称
      studioId: values.studioId, // 演播室id
      ip1: values.ip1, // 主服务ip
      ip2: values.ip2, // 备服务ip
      port1: values.port1, // 主服务器端口
      port2: values.port2, // 备服务器端口
      sceneNameS: values.sceneNameS, // 主场景地址
      sceneNameQ: values.sceneNameQ, // 备场景地址
      type: values.type, // 弹幕类型
      intervalTime: values.intervalTime, // 弹幕轮询时间间隔
      bulletChatNums: values.bulletChatNums, // 筛选弹幕限制数量
      powerTime: values.powerTime// 发电时刻开启服务时，默认时间间隔
    }
    try {
      if (id) {
        params.id = id
      }
      console.log('params===>', params)
      const { status } = id ? await UpdateApi(params) : await AddApi(params)
      if (status === 200) {
        id ? message.success('编辑成功') : message.success('创建成功')
        handleUpdateVisible(false, 'add')
      }
    } catch (error) {
      console.log(error)
    }
  }

  return (
    <ModalForm
    title={title}
    visible={visible}
    autoFocusFirstInput
    modalProps={{
      onCancel: cnacelClick,
      destroyOnClose: true
    }}
    onFinish={async (e) => {
      okClick(e)
    }}
    request={fetchDetail}>
      <ProForm.Group>
        <ProFormText width="md" name="studioName" label="演播室名称" placeholder="请输入演播室名称" />
        <ProFormDigit width="md" name="studioId" label="演播室id" placeholder="请输入演播室id" />
      </ProForm.Group>
      <ProForm.Group>
        <ProFormText width="md" name="ip1" label="主服务ip" placeholder="请输入主服务ip" />
        <ProFormText width="md" name="port1" label="主服务器端口" placeholder="请输入主服务器端口" />
      </ProForm.Group>
      <ProForm.Group>
        <ProFormText width="md" name="ip2" label="备服务ip" placeholder="请输入备服务ip" />
        <ProFormText width="md" name="port2" label="备服务器端口" placeholder="请输入备服务器端口" />
      </ProForm.Group>
      <ProForm.Group>
        <ProFormText width="md" name="sceneNameS" label="主场景地址" placeholder="请输入主场景地址" />
        <ProFormText width="md" name="sceneNameQ" label="备场景地址" placeholder="请输入备场景地址" />
      </ProForm.Group>
      <ProForm.Group>
        <ProFormSelect
          width="md"
          label="弹幕类型"
          name="type"
          placeholder='请选择弹幕类型'
          valueEnum={{
            1: '入库并存为txt',
            2: '只保存txt',
            3: '发送tcp并存为txt'
          }}
        />
        <ProFormDigit width="md" name="intervalTime" label="弹幕轮询时间间隔" addonAfter="秒" placeholder="请输入弹幕轮询时间间隔" />
      </ProForm.Group>
      <ProForm.Group>
        <ProFormDigit width="md" name="bulletChatNums" label="筛选弹幕限制条数" placeholder="请输入筛选弹幕限制数量" />
        <ProFormDigit width="md" name="powerTime" label="发电轮询时间间隔" addonAfter="秒" placeholder="请输入发电轮询时间间隔" />
      </ProForm.Group>
    </ModalForm>
  )
}
export default AddUpdate
